import alice.logictuple.*;
import alice.tucson.api.*;
import java.io.BufferedInputStream;

/**
 * The Chat Room setups the tuple centre,
 * with proper specification.
 *
 * @author  Rossella Rubino
 *
 */
public class ChatRoom {

    public static void main (String args[]) throws Exception {
        if (args.length!=1){
            System.err.println("args: < IP address of the TuCSoN node where the chat service must be located >");
            System.exit(-1);
        }
        TupleCentreId tid=new TupleCentreId("chat_room @ '"+args[0]+"'");
        try {

            Tucson.enterDefaultContext().setSpec(tid,alice.util.Tools.loadText(
                       new BufferedInputStream(ClassLoader.getSystemResourceAsStream("chat_spec.rsp"))));
            System.out.println("ok.");
        } catch (Exception ex){
            ex.printStackTrace();
            System.exit(-1);
        }
    }
}

